//	CFile.h

#ifndef _H_CFile
#define _H_CFile

#include "CEntry.h"

class CFile : public CEntry {
	
	public:
	
	OSErr		IFile(
		CDisk				*cDisk, 
		CFolder				*cParentFolder, 
		DiskLocSpecUnion	diskLoc, 
		EntryIndex			diskLocDirEntryIndex,	//	relative to cur dir sector
		EntryIndex			directoryIndex			//	relative to entire directory
	);

	virtual	Err				EntryDispatchCB(
		O_CBType			cbType, 
		O_CBDataP			cbData);

	virtual	void		SetFileAndAuxType(Byte fileType, ushort auxType);

	virtual	ushort		GetLoadAddress(void);
	virtual	void		SetLoadAddress(ushort address);
	
	virtual	OSErr 		ReadFile(Byte *buffer, long length);
	virtual	OSErr 		WriteFile(Byte *buffer, long length);

	virtual ADFS_IconType		GetIconType(void);
	virtual	void		SetBinFileType(void);

	virtual	long		GetFirstBufOffset(void);

	virtual	COffscreen	*CopyFilePicToCOffs(void);
	virtual	void		CopyFileTextToClipboard(void);
	virtual	Handle		CopyFileToHandle(Boolean translateB = TRUE);
	virtual	void		GetPreview(ADFS_PreviewRec *previewRecP);
	virtual	void		Open(void);

	virtual	void		GetAccessBits(Gen_AccessBits *bits);
	
	/**********************************************/
	Boolean		i_openingB;

	private:
	typedef CEntry _inherited;
};

#endif
